$(document).ready(function()
{
	user.show_main_view_intreface()
	user.show_errors_info()
	
	const network_settings_script = utils.load_script('network_settings.js')
	const device_info_script = utils.load_script('device_info.js')
    Promise.all([network_settings_script,
				device_info_script])
	.then(() => utils.load_script('app_sw_control.js'))
	.then(() => utils.load_script('app_sw.js'))
	.then(() => app_sw_control.main())
	.then(() => app_sw.main())
	.then(() => mcu_common.request_board_types())
	.then(text => common.response_ready(text))
	.then(values => async function(values) {
		await device_info.show()
		let product_code = values[0]
		let product_code_arr = utils.ip2array(product_code)
		await network_settings.show(product_code_arr)
		//network_settings.show(55) //for special ETS without CAN
	}(values))
	.then(() => {
		user.on_page_loading_finished()
		user.load_page()
	})
})
